
// NvidiaDecoderDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CNvidiaDecoderDlg dialog
class CNvidiaDecoderDlg : public CDialogEx
{
// Construction
public:
	CNvidiaDecoderDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CNvidiaDecoderDlg)
	enum { IDD = IDD_NVIDIADECODER_DIALOG };
	CStatic			m_statWindow;
	CButton		m_btnStart;
	CButton		m_btnStop;
	CButton		m_btnBrowser;
	CEdit			m_editFilePath;
	//}}AFX_DATA

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnBnClickedBtnStart();
	afx_msg void OnBnClickedBtnStop();
	afx_msg void OnBnClickedBtnBrowser();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	CString				GetWorkingPath( );

	BOOL				IsFileExists( const TCHAR* pFile );

	CStringVector SplitString( const CString& strSource, const CString& delim, bool bRemoveNone );

public:	

	DEVICE_HANDLE				m_hVideoSwDecoderDev;						// H265 NVIDIA NVENC DECODER DEVICE	

	CRITICAL_SECTION			m_hAccessFileCriticalSection;					// FILE ACCESS CRITICAL SECTION

	BOOL									m_bDecodeBuffer;	

	HANDLE								m_hVideoDecodeThread;

	ULONG								m_hVideoDecodeThreadNumber;

	BYTE *								m_pH265FrameBuffer;

	ULONG								m_nH265FrameBufferLen;	
	
	CString									m_strFilePath;

	CStdioFile *							m_pTxtFile;

	CFile *									m_pBinFile;	
};
